#version 140
#extension GL_EXT_gpu_shader4 : enable
// Water RippleMod01.fsh  by   lschmidt
//https://www.shadertoy.com/view/4dVcWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(680,420,0,0)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // parameters
    float wave = 10.0;
    float velocity1 = 3.0;
    float raio = 1.0;
    // parameters
    
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    
    vec2 mouse = iMouse.xy/iResolution.xy;
    
    float dist = distance(uv,mouse);
    
    float ripple = cos(sin(dist*wave-iTime*velocity1));
    
    vec3 col;
    
    if(dist<raio)
    	col = texture2D(iChannel0,uv+ripple).rgb;
    else
        col = texture2D(iChannel0,uv).rgb;
    
    gl_FragColor = vec4(col,1.0);
}




